<?php

// Code taken from various random public places on the Internet.

class MakeHumanReadable {

	function fromBytesToHumanReadable($bytes, $precision = 2) {
		return $this->formatBytes($bytes, $precision);
	}

	function formatBytes($bytes, $precision = 2) {
		$units = array('B', 'KB', 'MB', 'GB', 'TB');

		$bytes = max($bytes, 0);
		$pow = floor(($bytes ? log($bytes) : 0) / log(1024));
		$pow = min($pow, count($units) - 1);

		return round($bytes, $precision) . ' ' . $units[$pow];
	}

	function FileSize($file, $setup = null) {
		$FZ = ($file && @is_file($file)) ? filesize($file) : NULL;
		$FS = array("B", "kB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB");

		if (!$setup && $setup !== 0) {
			return number_format($FZ / pow(1024, $I = floor(log($FZ, 1024))), ($i >= 1) ? 2 : 0) . ' ' . $FS[$I];
		} elseif ($setup == 'INT')
			return number_format($FZ);
		else
			return number_format($FZ / pow(1024, $setup), ($setup >= 1) ? 2 : 0 ) . ' ' . $FS[$setup];
	}
}

?>
